; Game.s : ゲーム
;


; モジュール宣言
;
    .module Game

; 参照ファイル
;
    .include    "bios.inc"
    .include    "vdp.inc"
    .include    "System.inc"
    .include    "App.inc"
    .include	"Game.inc"

; 外部変数宣言
;

; マクロの定義
;


; CODE 領域
;
    .area   _CODE

; ゲームを初期化する
;
_GameInitialize::
    
    ; レジスタの保存
    
    ; スプライトのクリア
    call    _SystemClearSprite
    
    ; パターンネームの設定
    ld      hl, #(_patternName + 0x0000)
    ld      de, #(_patternName + 0x0001)
    ld      bc, #0x02ff
    ld      (hl), #0x00
    ldir
    ld      hl, #(_patternName + 0x0200)
    ld      b, #0x08
10$:
    ld      (hl), #0x88
    inc     hl
    ld      (hl), #0x89
    inc     hl
    ld      (hl), #0x8a
    inc     hl
    ld      (hl), #0x8b
    inc     hl
    djnz    10$
    ld      b, #0x08
11$:
    ld      (hl), #0x8c
    inc     hl
    ld      (hl), #0x8d
    inc     hl
    ld      (hl), #0x8e
    inc     hl
    ld      (hl), #0x8f
    inc     hl
    djnz    11$
    
    ; ゲームの初期化
    ld      hl, #gameDefault
    ld      de, #_game
    ld      bc, #GAME_LENGTH
    ldir
    
    ; 描画の開始
    ld      hl, #(_videoRegister + VDP_R1)
    set     #VDP_R1_BL, (hl)
    
    ; ＢＧＭの再生
    ld      hl, #gameSoundBgm0
    ld      (_soundChannel + SOUND_CHANNEL_A + SOUND_CHANNEL_REQUEST), hl
    ld      hl, #gameSoundBgm1
    ld      (_soundChannel + SOUND_CHANNEL_B + SOUND_CHANNEL_REQUEST), hl
    ld      hl, #gameSoundBgm2
    ld      (_soundChannel + SOUND_CHANNEL_C + SOUND_CHANNEL_REQUEST), hl
    
    ; 状態の設定
    ld      a, #GAME_STATE_WALK
    ld      (_game + GAME_STATE), a
    ld      a, #APP_STATE_GAME_UPDATE
    ld      (_appState), a
    
    ; レジスタの復帰
    
    ; 終了
    ret

; ゲームを更新する
;
_GameUpdate::
    
    ; レジスタの保存
    
    ; スプライトのクリア
    call    _SystemClearSprite

    ; 状態別の処理
    ld      hl, #10$
    push    hl
    ld      a, (_game + GAME_STATE)
    and     #0xf0
    rrca
    rrca
    rrca
    ld      e, a
    ld      d, #0x00
    ld      hl, #gameProc
    add     hl, de
    ld      e, (hl)
    inc     hl
    ld      d, (hl)
    ex      de, hl
    jp      (hl)
;   pop     hl
10$:

    ; スプライトの描画
    ld      hl, #(_game + GAME_ANIMATION)
    ld      a, (hl)
    and     #0xfe
    add     a, a
    and     #0xf0
    ld      e, a
    ld      d, #0x00
    ld      hl, #gameSprite
    add     hl, de
    ld      de, #(_sprite + GAME_SPRITE_NULL)
    ld      b, #0x03
20$:
    ld      a, (_game + GAME_POSITION_Y)
    add     a, (hl)
    ld      (de), a
    inc     hl
    inc     de
    ld      a, (_game + GAME_POSITION_X)
    add     a, (hl)
    ld      (de), a
    inc     hl
    inc     de
    ld      a, (hl)
    ld      (de), a
    inc     hl
    inc     de
    ld      a, (hl)
    ld      (de), a
    inc     hl
    inc     de
    djnz    20$

    ; フレームの更新
    ld      hl, #(_game + GAME_FRAME)
    inc     (hl)

    ; レジスタの復帰
    
    ; 終了
    ret

; 何もしない
;
GameNull:

    ; レジスタの保存

    ; レジスタの復帰

    ; 終了
    ret

; 歩く
;
GameWalk:
    
    ; レジスタの保存
    
    ; 初期化の開始
    ld      a, (_game + GAME_STATE)
    and     #0x0f
    jr      nz, 09$
    
    ; 初期化の完了
    ld      hl, #(_game + GAME_STATE)
    inc     (hl)
09$:
    
    ; アニメーションの更新
    ld      hl, #(_game + GAME_ANIMATION)
    ld      a, (hl)
    inc     a
    and     #0x1f
    ld      (hl), a
    
    ; 位置の更新
    ld      hl, #(_game + GAME_POSITION_X)
    inc     (hl)
    
    ; SPACE バーの入力
    ld      a, (_input + INPUT_BUTTON_SPACE)
    dec     a
    jr      nz, 19$
    
    ; 状態の更新
    ld      a, #GAME_STATE_JUMP
    ld      (_game + GAME_STATE), a
19$:

    ; レジスタの復帰
    
    ; 終了
    ret

; ジャンプする
;
GameJump:
    
    ; レジスタの保存
    
    ; 初期化の開始
    ld      a, (_game + GAME_STATE)
    and     #0x0f
    jr      nz, 09$
    
    ; ジャンプの設定
    ld      a, #0xf0
    ld      (_game + GAME_JUMP), a
    
    ; アニメーションの設定
    ld      a, #0x20
    ld      (_game + GAME_ANIMATION), a
    
    ; ＳＥの再生
    ld      hl, #gameSoundJump
    ld      (_soundChannel + SOUND_CHANNEL_D + SOUND_CHANNEL_REQUEST), hl
    
    ; 初期化の完了
    ld      hl, #(_game + GAME_STATE)
    inc     (hl)
09$:
    
    ; 位置の更新
    ld      hl, #(_game + GAME_POSITION_X)
    inc     (hl)
    inc     hl
    ld      de, #(_game + GAME_JUMP)
    ld      a, (de)
    sra     a
    sra     a
    add     a, (hl)
    ld      (hl), a
    cp      #0x80
    jr      nc, 10$
    ex      de, hl
    inc     (hl)
    jr      19$
10$:
    ld      a, #0x80
    ld      (hl), a
    
    ; 状態の更新
    ld      a, #GAME_STATE_WALK
    ld      (_game + GAME_STATE), a
19$:

    ; レジスタの復帰
    
    ; 終了
    ret

; 定数の定義
;

; 状態別の処理
;
gameProc:
    
    .dw     GameNull
    .dw     GameWalk
    .dw     GameJump

; ゲームの初期値
;
gameDefault:

    .db     GAME_STATE_NULL
    .db     GAME_FRAME_NULL
    .db     0x80 ; GAME_POSITION_NULL
    .db     0x80 ; GAME_POSITION_NULL
    .db     0xf0 ; GAME_JUMP_NULL
    .db     GAME_ANIMATION_NULL
    
; スプライト
;
gameSprite:

;   .db     0xef, 0xf8, 0x20, 0x0a, 0xef, 0xf8, 0x40, 0x0c, 0xef, 0xf8, 0x60, 0x08, 0x00, 0x00, 0x00, 0x00
;   .db     0xef, 0xf8, 0x24, 0x0a, 0xef, 0xf8, 0x44, 0x0c, 0xef, 0xf8, 0x64, 0x08, 0x00, 0x00, 0x00, 0x00
;   .db     0xef, 0xf8, 0x28, 0x0a, 0xef, 0xf8, 0x48, 0x0c, 0xef, 0xf8, 0x68, 0x08, 0x00, 0x00, 0x00, 0x00
;   .db     0xef, 0xf8, 0x24, 0x0a, 0xef, 0xf8, 0x44, 0x0c, 0xef, 0xf8, 0x64, 0x08, 0x00, 0x00, 0x00, 0x00
;   .db     0xef, 0xf8, 0x2c, 0x0a, 0xef, 0xf8, 0x4c, 0x0c, 0xef, 0xf8, 0x6c, 0x08, 0x00, 0x00, 0x00, 0x00
    .db     0xef, 0xf8, 0x30, 0x0a, 0xef, 0xf8, 0x50, 0x04, 0xef, 0xf8, 0x70, 0x08, 0x00, 0x00, 0x00, 0x00
    .db     0xef, 0xf8, 0x34, 0x0a, 0xef, 0xf8, 0x54, 0x04, 0xef, 0xf8, 0x74, 0x08, 0x00, 0x00, 0x00, 0x00
    .db     0xef, 0xf8, 0x38, 0x0a, 0xef, 0xf8, 0x58, 0x04, 0xef, 0xf8, 0x78, 0x08, 0x00, 0x00, 0x00, 0x00
    .db     0xef, 0xf8, 0x34, 0x0a, 0xef, 0xf8, 0x54, 0x04, 0xef, 0xf8, 0x74, 0x08, 0x00, 0x00, 0x00, 0x00
    .db     0xef, 0xf8, 0x3c, 0x0a, 0xef, 0xf8, 0x5c, 0x04, 0xef, 0xf8, 0x7c, 0x08, 0x00, 0x00, 0x00, 0x00

; サウンド
;
gameSoundBgm0:
    
;   .ascii  "T1@*@16V15,4L5"
;   .ascii  "O4CO5CO3AO4AO3B-O4B-R7R9"
;   .ascii  "O4CO5CO3AO4AO3B-O4B-R7R9"
;   .ascii  "O3FO4FO3DO4DO3E-O4E-R7R9"
;   .ascii  "O3FO4FO3DO4DO3E-O4E-R7R9"
;   .ascii  "R7T5L0O4E-DD-T1RL7CE-DO3A-GO4D-"
;   .ascii  "L0T5O4CG-E-T1RT5EB-AT1R"
;   .ascii  "L1T5O4A-E-O3BT1RT5B-AA-T1R"
;   .ascii  "L9RRR"
;   .db     0xff
    .ascii  "T3V15,5L3"
    .ascii  "@*@16"
    .ascii  "O5C4CR1O4GB-AGFE4FR1G5EC5"
    .ascii  "O5C4CR1O4GB-AGFE4FR1GREC5"
    .ascii  "@*@16"
    .ascii  "O5C4CR1DE-DC5E-1D1CE-DC5R5"
    .ascii  "O5C4CR1O4GB-AGFE4FR1GREC5"
    .ascii  "@*@16"
    .ascii  "O4A-7R5O5CE-D4C1RO4B-6R5"
    .ascii  "O5C7EDCO4GB-AGAG5R5"
    .db     0xff

gameSoundBgm1:
    
;   .ascii  "T1@16V15,4L5"
;   .db     0x00
    .ascii  "T3@0V16L3S0N2"
    .ascii  "M3XXM5XM3XXXM5XM3XM3XXM5XM3XXXM5XM3X"
    .ascii  "M3XXM5XM3XXXM5XM3XM3XXM5XM3XXXM5XM3X"
    .ascii  "M3XXM5XM3XXXM5XM3XM3XXM5XM3XXXM5XM3X"
    .ascii  "M3XXM5XM3XXXM5XM3XM3XXM5XM3XXXM5XM3X"
    .ascii  "M3XXM5XM3XXXM5XM3XM3XXM5XM3XXXM5XM3X"
    .ascii  "M3XXM5XM3XXXM5XM3XM3XXM5XM3XXXM5XM3X"
    .db     0xff
    
gameSoundBgm2:
    
;   .ascii  "T1@16V15,4L5"
;   .ascii  "O3CO4CO2AO3AO2B-O3B-R7R9"
;   .ascii  "O3CO4CO2AO3AO2B-O3B-R7R9"
;   .ascii  "O2FO3FO2DO3DO2E-O3E-R7R9"
;   .ascii  "O2FO3FO2DO3DO2E-O3E-R7R9"
;   .ascii  "R7T5L0O3E-DD-T1RL7CE-DO2A-GO3D-"
;   .ascii  "L0T5O3CG-E-T1RT5EB-AT1R"
;   .ascii  "L1T5O3A-E-O2BT1RT5B-AA-T1R"
;   .ascii  "L9RRR"
;   .db     0xff
    .ascii  "T3@0V13,5L3"
    .ascii  "@16"
    .ascii  "O3C4C1O4CO3GA+AGAC4C1O4CO3GRAA+5"
    .ascii  "O3C4C1O4CO3GA+AGAC4C1O4CO3GRAA+5"
    .ascii  "@16"
    .ascii  "O3F4F1O4CO3FAA+BO4CO3C4C1O4CO3AA+AGA"
    .ascii  "O3C4C1O4CO3GA+AGAC4C1O4CO3GRAA+5"
    .ascii  "@16"
    .ascii  "O3G+4O4D+4G+5CD+G+O3A+4O4F4A+5DFA+"
    .ascii  "O4C4G4O5C5O4EGO5CO4A+AGAG5R5"
    .db     0xff

gameSoundJump:
    
    .ascii  "T1@0V15L0O4A1O3ABO4C+D+FGABO5C+D+FGA"
    .db     0x00


; DATA 領域
;
    .area   _DATA

; 変数の定義
;

; ゲーム
;
_game::

    .ds     GAME_LENGTH
